#!/usr/bin/perl
#WHMADDON:csf:ConfigServer Security&<b>Firewall</b>
###############################################################################
# Copyright 2006-2013, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
# start main

use File::Find;
use Fcntl qw(:DEFAULT :flock);
use Sys::Hostname qw(hostname);
use IPC::Open3;

open (IN, "</etc/csf/version.txt") or die $!;
$myv = <IN>;
close (IN);
chomp $myv;

$script = "addon_csf.cgi";
$images = "csf";

use lib '/usr/local/cpanel';
use Cpanel::cPanelFunctions ();
use Cpanel::Form			();
use Cpanel::Config          ();
use Whostmgr::HTMLInterface ();
use Whostmgr::ACLS			();

Whostmgr::ACLS::init_acls();

print "Content-type: text/html\r\n\r\n";

open (IN,"<","/etc/csf/csf.resellers");
while (my $line = <IN>) {
	my ($user,$alert,$privs) = split(/\:/,$line);
	$privs =~ s/\s//g;
	foreach my $priv (split(/\,/,$privs)) {
		$rprivs{$user}{$priv} = 1;
	}
	$rprivs{$user}{ALERT} = $alert;
}
close (IN);
$reseller = 0;
if (!Whostmgr::ACLS::hasroot()) {
	if ($rprivs{$ENV{REMOTE_USER}}{USE}) {
		$reseller = 1;
	} else {
		print "You do not have access to ConfigServer Firewall.\n";
		exit();
	}
}

eval ('use Cpanel::Rlimit			();');
unless ($@) {Cpanel::Rlimit::set_rlimit_to_infinity()}

$Cpanel::App::appname = "whostmgr";
Whostmgr::HTMLInterface::defheader("ConfigServer Security & Firewall - csf v$myv",'/cgi/csf/csf_small.png','/cgi/addon_csf.cgi');

%FORM = Cpanel::Form::parseform();

$dns = -e '/var/cpanel/dnsonly' ? 1 : 0;

if ($reseller) {
	do "/etc/csf/csfuir.pl";
} else {
	do "/etc/csf/csfui.pl";
}

1;
