#!/usr/bin/perl
use strict;

		my ($status, $text) = &urlget("http://www.configserver.com/free/csf/version.txt");
		if ($status) {print "Oops: $text\n"}
		print "Latest : $text\n";

		my $mailscanner = 'http://www.mailscanner.info/files/4/tar/MailScanner-install-4.84.5-2.tar.gz';
		my $msfile = (split (/\//,$mailscanner))[-1];
		($status, $text) = &urlget($mailscanner,"/usr/src/$msfile");
		if ($status) {print "Oops: $text\n"}

			print "Done\n";

###############################################################################
# start urlget
sub urlget {
	my $url = shift;
	my $file = shift;
	my $status = 0;
	my $timeout = 1200;

	use HTTP::Tiny;
	my $ua = HTTP::Tiny->new;
	$ua->agent("ConfigServer");
	$ua->timeout($timeout);
	my $res;
	my $text;

	($status, $text) = eval {
		local $SIG{__DIE__} = undef;
		local $SIG{'ALRM'} = sub {die "Download timeout after $timeout seconds"};
		alarm($timeout);
		if ($file) {
			$|=1;
			my $expected_length;
			my $bytes_received = 0;
			my $per = 0;
			my $oldper = 0;
			open (OUT, ">$file\.tmp") or return (1, "Unable to open $file\.tmp: $!");
			binmode (OUT);
			$res = $ua->request('GET', $url, {
				data_callback => sub {
					my($chunk, $res) = @_;
					$bytes_received += length($chunk);
					unless (defined $expected_length) {$expected_length = $res->{headers}->{'content-length'} || 0}
					if ($expected_length) {
						my $per = int(100 * $bytes_received / $expected_length);
						if ((int($per / 5) == $per / 5) and ($per != $oldper)) {
							print "...$per\%\n";
							$oldper = $per;
						}
					} else {
						print ".";
					}
					print OUT $chunk;
				}
			});
			close (OUT);
			print "\n";
		} else {
			$res = $ua->request('GET', $url);
		}
		alarm(0);
		if ($res->{success}) {
			if ($file) {
				rename ("$file\.tmp","$file") or return (1, "Unable to rename $file\.tmp to $file: $!");
				return (0, $file);
			} else {
				return (0, $res->{content});
			}
		} else {
			my $reason = $res->{reason};
			if ($res->{status} == 599) {$reason = $res->{content}}
			return (1, "Unable to download: ".$res->{status}." - $reason");
		}
	};
	alarm(0);
	if ($@) {return (1, $@)}
	return ($status,$text);
}
# end urlget
###############################################################################

